---@param name string The access name of the spray.
---@param texture TextureInfo The texture of the spray.
---@return boolean
local function api_create_spray(name, texture) -- Creates a custom spray. Use get_texture_info to get the texture.
    table.insert(spray_table, {name = name, texture = texture})
    log_to_console('Spray added via API with name "' .. name .. '"', CONSOLE_MESSAGE_INFO)
    return true
end

---@param name string The access name of the spray to edit.
---@param func function This can take in the old spray: {name = string, texture = TextureInfo}, and return the new edited spray to replace the old one with.
---@return boolean
local function api_edit_spray(name, func) -- Edits a spray based on the function you provide it. [ DOES NOT EDIT EXISTING SPRAYS ]
    for i = 1, #spray_table do
        local spray = spray_table[i]

        if spray.name == name then
            spray_table[i] = func(spray) -- assume function takes in the spray, and also returns the edited spray
            log_to_console('Spray "' .. name .. '" was changed via API', CONSOLE_MESSAGE_INFO)
            return true
        end
    end

    log_to_console('Unable to find spray with name "' .. name .. '"', CONSOLE_MESSAGE_WARNING)
    return false
end

_G.sprayModExists = true

_G.sprayMod = {
    create_spray = api_create_spray,
    edit_spray = api_edit_spray,
}